unit DBAliasCollection;

interface
  uses DBAlias, System.Collections, System.Configuration;

type
  TDBAliasCollection = class(CollectionBase)
  private
    function GetDBAlias(i: integer): TDBAlias;
    procedure SetDBAlias(i: integer; const Value: TDBAlias);
  strict protected
    procedure OnInsert(index: Integer; value: TObject); override;
    procedure OnValidate(value: TObject); override;
    procedure OnRemove(index: Integer; value: TObject); override;
    procedure OnSet(index: Integer; oldValue: TObject; newValue: TObject); override;
  public
    constructor Create;
    function Add(value : TDBAlias): integer;
    function IndexOf(value : TDBAlias): integer;
    procedure Remove(value : TDBAlias);
    function Contains(value : TDBAlias) : boolean;
    property Item[i : integer] : TDBAlias read GetDBAlias write SetDBAlias; default;

    class function DBAlias(name : string) : TDBAlias;
  end;

implementation

constructor TDBAliasCollection.Create;
begin
  inherited Create;
  // TODO: Add any constructor code here
end;

procedure TDBAliasCollection.OnInsert(index: Integer; value: TObject);
begin
  if value.GetType() <> typeof(TDBAlias) then
    raise  ArgumentException.Create('value must be of type TDBAlias.', 'value');
end;

procedure TDBAliasCollection.OnSet(index: Integer; oldValue,
  newValue: TObject);
begin
  if newValue.GetType() <> typeof(TDBAlias) then
    raise  ArgumentException.Create('value must be of type TDBAlias.', 'value');
end;

procedure TDBAliasCollection.OnValidate(value: TObject);
begin
  if value.GetType() <> typeof(TDBAlias) then
    raise  ArgumentException.Create('value must be of type TDBAlias.', 'value');
end;

procedure TDBAliasCollection.OnRemove(index: Integer; value: TObject);
begin
  if value.GetType() <> typeof(TDBAlias) then
    raise  ArgumentException.Create('value must be of type TDBAlias.', 'value');
end;

function TDBAliasCollection.Add(value: TDBAlias): integer;
begin
  result :=  List.Add(value);
end;

function TDBAliasCollection.IndexOf(value: TDBAlias): integer;
begin
  Result := List.IndexOf(value);
end;

function TDBAliasCollection.Contains(value: TDBAlias): boolean;
begin
  Result := List.Contains(value)
end;

procedure TDBAliasCollection.Remove(value: TDBAlias);
begin
  List.Remove(value);
end;

procedure TDBAliasCollection.SetDBAlias(i: integer;
  const Value: TDBAlias);
begin
  List[i] := Value;
end;

function TDBAliasCollection.GetDBAlias(i: integer): TDBAlias;
begin
  Result := TDBAlias(List[i]);
end;

class function TDBAliasCollection.DBAlias(name: string): TDBAlias;
var
  dba, return : TDBAlias;
  coll : TDBAliasCollection;

begin
  coll := ConfigurationSettings.GetConfig('StoreAdminDatabases') as TDBAliasCollection;

  Return := nil;
  for dba in coll.List do
  begin
    if dba.Name.Equals(name) then
    begin
      Return := dba;
      Break;
    end;
  end;
  Result := Return;
end;

end.
